/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentState;
import jade.core.AgentToolkit;
import jade.core.BaseNode;
import jade.core.CaseInsensitiveString;
import jade.core.Command;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.LADT;
import jade.core.Location;
import jade.core.MainContainer;
import jade.core.NameClashException;
import jade.core.NodeDescriptor;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.Runtime;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.ServiceManager;
import jade.core.ServiceNotActiveException;
import jade.core.Specifier;
import jade.core.management.AgentManagementSlice;
import jade.core.messaging.GenericMessage;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.lang.acl.ACLMessage;
import jade.mtp.TransportAddress;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;

class AgentContainerImpl
implements AgentContainer,
AgentToolkit {
    public static final String ENABLE_MONITOR = "jade_core_AgentContainerImpl_enablemonitor";
    public static final String MONITOR_AGENT_NAME = "monitor-%C";
    public static final String MONITOR_AGENT_CLASS = "jade.core.ContainerMonitorAgent";
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    protected LADT localAgents;
    protected Profile myProfile;
    protected CommandProcessor myCommandProcessor;
    protected IMTPManager myIMTPManager;
    private ServiceManager myServiceManager;
    private ServiceFinder myServiceFinder;
    private ResourceManager myResourceManager;
    protected ContainerID myID;
    protected NodeDescriptor myNodeDescriptor;
    protected JADEPrincipal ownerPrincipal;
    protected Credentials ownerCredentials;
    private AID theAMS;
    private AID theDefaultDF;

    AgentContainerImpl() {
    }

    AgentContainerImpl(Profile p) {
        this.myProfile = p;
        this.localAgents = new LADT(16);
    }

    public void initAgent(AID agentID, Agent instance, JADEPrincipal ownerPrincipal, Credentials initialCredentials) throws NameClashException, IMTPException, NotFoundException, JADESecurityException {
        agentID.setName(JADEManagementOntology.adjustAgentName(agentID.getName(), new String[]{this.myID.getName()}));
        instance.setAID(agentID);
        instance.setToolkit(this);
        GenericCommand cmd = new GenericCommand("Inform-Created", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        cmd.addParam(instance);
        cmd.addParam(ownerPrincipal);
        cmd.addParam(initialCredentials);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NameClashException) {
                throw (NameClashException)ret;
            }
            if (ret instanceof IMTPException) {
                throw (IMTPException)ret;
            }
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof JADESecurityException) {
                throw (JADESecurityException)ret;
            }
            if (ret instanceof Throwable) {
                ((Throwable)ret).printStackTrace();
            }
        }
    }

    public NodeDescriptor getNodeDescriptor() {
        return this.myNodeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IMTPException, ProfileException {
        this.myCommandProcessor = this.myProfile.getCommandProcessor();
        try {
            this.myIMTPManager = this.myProfile.getIMTPManager();
            this.myIMTPManager.initialize(this.myProfile);
        }
        finally {
            if (this.myProfile.getBooleanProperty("dump-options", false)) {
                this.myLogger.log(8, "Startup options dump:\n" + this.myProfile);
            }
        }
        this.myServiceManager = this.myProfile.getServiceManager();
        this.myServiceFinder = this.myProfile.getServiceFinder();
        BaseNode localNode = (BaseNode)this.myIMTPManager.getLocalNode();
        localNode.setCommandProcessor(this.myCommandProcessor);
        localNode.setServiceManager(this.myServiceManager);
        AID.setPlatformID(this.myServiceManager.getPlatformName());
        this.theAMS = new AID("ams", false);
        this.theDefaultDF = new AID("df", false);
        this.myResourceManager = this.myProfile.getResourceManager();
        TransportAddress addr = (TransportAddress)this.myIMTPManager.getLocalAddresses().get(0);
        this.myID = new ContainerID(this.myProfile.getParameter("container-name", "No-Name"), addr);
        this.myNodeDescriptor = new NodeDescriptor(this.myID, this.myIMTPManager.getLocalNode());
    }

    protected void startNode() throws IMTPException, ProfileException, ServiceException, JADESecurityException, NotFoundException {
        ArrayList services = new ArrayList();
        ServiceDescriptor dsc = this.startService("jade.core.management.AgentManagementService", false);
        dsc.setMandatory(true);
        services.add(dsc);
        dsc = this.startService("jade.core.messaging.LightMessagingService", false);
        dsc.setMandatory(true);
        services.add(dsc);
        List l = this.myProfile.getSpecifiers("services");
        this.myProfile.setSpecifiers("services", l);
        Iterator serviceSpecifiers = l.iterator();
        while (serviceSpecifiers.hasNext()) {
            Specifier s = (Specifier)serviceSpecifiers.next();
            String serviceClass = s.getClassName();
            boolean isMandatory = false;
            if (s.getArgs() != null) {
                isMandatory = CaseInsensitiveString.equalsIgnoreCase((String)s.getArgs()[0], "true");
            }
            try {
                dsc = this.startService(serviceClass, false);
                dsc.setMandatory(isMandatory);
                services.add(dsc);
            }
            catch (ServiceException se) {
                if (isMandatory) {
                    throw se;
                }
                this.myLogger.log(9, "Exception initializing service " + serviceClass + " : " + se.toString());
                se.printStackTrace();
            }
        }
        ServiceDescriptor[] descriptors = new ServiceDescriptor[services.size()];
        int i = 0;
        while (i < descriptors.length) {
            descriptors[i] = (ServiceDescriptor)services.get(i);
            ++i;
        }
        this.myServiceManager.addNode(this.myNodeDescriptor, descriptors);
        int i2 = 0;
        while (i2 < descriptors.length) {
            ServiceDescriptor currentServDesc = descriptors[i2];
            try {
                currentServDesc.getService().boot(this.myProfile);
            }
            catch (Throwable t) {
                if (currentServDesc.isMandatory()) {
                    throw new ServiceException("An error occurred during service booting", t);
                }
                this.myLogger.log(9, "Exception booting service " + currentServDesc.getName() + " : " + t.toString());
                t.printStackTrace();
            }
            ++i2;
        }
    }

    boolean joinPlatform() {
        try {
            this.init();
            this.startNode();
        }
        catch (IMTPException imtpe) {
            this.myLogger.log(10, "Communication failure while joining agent platform: " + imtpe.getMessage());
            imtpe.printStackTrace();
            this.endContainer();
            this.cleanIMTPManager();
            return false;
        }
        catch (JADESecurityException ae) {
            this.myLogger.log(10, "Authentication or authorization failure while joining agent platform.");
            ae.printStackTrace();
            this.endContainer();
            this.cleanIMTPManager();
            return false;
        }
        catch (Exception e) {
            this.myLogger.log(10, "Some problem occurred while joining agent platform.");
            e.printStackTrace();
            this.endContainer();
            this.cleanIMTPManager();
            return false;
        }
        this.startBootstrapAgents();
        this.myLogger.log(8, "--------------------------------------\nAgent container " + this.myID + " is ready.\n--------------------------------------------");
        return true;
    }

    private void cleanIMTPManager() {
        if (this.myIMTPManager != null) {
            this.myIMTPManager.shutDown();
        }
    }

    private void startBootstrapAgents() {
        try {
            List l = this.myProfile.getSpecifiers("agents");
            Iterator agentSpecifiers = l.iterator();
            while (agentSpecifiers.hasNext()) {
                Specifier s = (Specifier)agentSpecifiers.next();
                if (s.getName() != null) {
                    AID agentID = new AID(s.getName(), false);
                    try {
                        String serviceName = "jade.core.management.AgentManagement";
                        Service svc = this.myServiceFinder.findService(serviceName);
                        AgentManagementSlice target = (AgentManagementSlice)this.myIMTPManager.createSliceProxy(serviceName, svc.getHorizontalInterface(), this.myIMTPManager.getLocalNode());
                        GenericCommand dummyCmd = new GenericCommand(null, null, null);
                        dummyCmd.setPrincipal(this.myNodeDescriptor.getOwnerPrincipal());
                        dummyCmd.setCredentials(this.myNodeDescriptor.getOwnerCredentials());
                        target.createAgent(agentID, s.getClassName(), s.getArgs(), this.myNodeDescriptor.getOwnerPrincipal(), null, false, dummyCmd);
                    }
                    catch (Throwable t) {
                        this.myLogger.log(10, "Cannot create agent " + s.getName() + ": " + t.getMessage());
                    }
                    continue;
                }
                this.myLogger.log(9, "Cannot create an agent with no name. Class was " + s.getClassName());
            }
            AID[] allLocalNames = this.localAgents.keys();
            int i = 0;
            while (i < allLocalNames.length) {
                AID id = allLocalNames[i];
                if (!id.equals(this.theAMS) && !id.equals(this.theDefaultDF)) {
                    try {
                        this.powerUpLocalAgent(id);
                    }
                    catch (NotFoundException nfe) {
                        nfe.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (ProfileException pe) {
            this.myLogger.log(9, "Error reading initial agents. " + pe);
            pe.printStackTrace();
        }
    }

    public void shutDown() {
        Agent[] allLocalAgents = this.localAgents.values();
        int i = 0;
        while (i < allLocalAgents.length) {
            Agent a = allLocalAgents[i];
            AID id = a.getAID();
            if (!id.equals(this.getAMS()) && !id.equals(this.getDefaultDF())) {
                a.doDelete();
                a.join();
                a.resetToolkit();
            }
            ++i;
        }
        try {
            this.myServiceManager.removeNode(this.myNodeDescriptor);
            this.myIMTPManager.shutDown();
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
        this.myResourceManager.releaseResources();
        this.endContainer();
    }

    private void endContainer() {
        try {
            Runtime.instance().endContainer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Location here() {
        return this.myID;
    }

    public void handleSend(ACLMessage msg, AID sender, boolean needClone) {
        Iterator it = msg.getAllIntendedReceiver();
        boolean isFirst = true;
        while (it.hasNext()) {
            AID receiver = (AID)it.next();
            if (isFirst) {
                needClone = needClone || it.hasNext();
                isFirst = false;
            }
            GenericCommand cmd = new GenericCommand("Send-Message", "jade.core.messaging.Messaging", null);
            cmd.addParam(sender);
            ACLMessage toBeSent = null;
            toBeSent = needClone ? (ACLMessage)msg.clone() : msg;
            isFirst = false;
            GenericMessage gmsg = new GenericMessage(toBeSent);
            cmd.addParam(gmsg);
            cmd.addParam(receiver);
            this.initCredentials(cmd, sender);
            Object ret = this.myCommandProcessor.processOutgoing(cmd);
            if (ret == null || !(ret instanceof Throwable)) continue;
            cmd = new GenericCommand("Notify-Failure", "jade.core.messaging.Messaging", null);
            cmd.addParam(gmsg);
            cmd.addParam(receiver);
            cmd.addParam(new InternalError("Message blocked: " + ret));
            ret = this.myCommandProcessor.processOutgoing(cmd);
            if (ret == null || !(ret instanceof Throwable)) continue;
            ((Throwable)ret).printStackTrace();
        }
    }

    public void handleChangedAgentState(AID agentID, int oldState, int newState) {
        AgentState from = AgentState.getInstance(oldState);
        AgentState to = AgentState.getInstance(newState);
        GenericCommand cmd = new GenericCommand("Inform-State-Changed", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        cmd.addParam(from);
        cmd.addParam(to);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void handleEnd(AID agentID) {
        GenericCommand cmd = new GenericCommand("Inform-Killed", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        this.initCredentials(cmd, agentID);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void setPlatformAddresses(AID id) {
        GenericCommand cmd = new GenericCommand("Set-Platform-Addresses", "jade.core.messaging.Messaging", null);
        cmd.addParam(id);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public AID getAMS() {
        return (AID)this.theAMS.clone();
    }

    public AID getDefaultDF() {
        return (AID)this.theDefaultDF.clone();
    }

    public String getProperty(String key, String aDefault) {
        return this.myProfile.getParameter(key, aDefault);
    }

    public ServiceHelper getHelper(Agent a, String serviceName) throws ServiceException {
        try {
            Service s = this.myServiceFinder.findService(serviceName);
            if (s == null) {
                throw new ServiceNotActiveException(serviceName);
            }
            return s.getHelper(a);
        }
        catch (IMTPException imtpe) {
            throw new ServiceException(" ServiceHelper could not be created for: " + serviceName, imtpe);
        }
    }

    public String getPlatformID() {
        return AID.getPlatformID();
    }

    public Agent addLocalAgent(AID id, Agent a) {
        a.setToolkit(this);
        return this.localAgents.put(id, a);
    }

    public void powerUpLocalAgent(AID agentID) throws NotFoundException {
        Agent instance = this.localAgents.acquire(agentID);
        if (instance == null) {
            throw new NotFoundException("powerUpLocalAgent() failed to find agent " + agentID.getName());
        }
        Thread t = this.myResourceManager.getThread(0, agentID.getLocalName(), instance);
        instance.powerUp(agentID, t);
        this.localAgents.release(agentID);
    }

    public void removeLocalAgent(AID id) {
        this.localAgents.remove(id);
    }

    public Agent acquireLocalAgent(AID id) {
        return this.localAgents.acquire(id);
    }

    public void releaseLocalAgent(AID id) {
        this.localAgents.release(id);
    }

    public AID[] agentNames() {
        return this.localAgents.keys();
    }

    public void addAddressToLocalAgents(String address) {
        Agent[] allLocalAgents = this.localAgents.values();
        int j = 0;
        while (j < allLocalAgents.length) {
            allLocalAgents[j].addPlatformAddress(address);
            ++j;
        }
        this.theAMS.addAddresses(address);
        this.theDefaultDF.addAddresses(address);
    }

    public void removeAddressFromLocalAgents(String address) {
        Agent[] allLocalAgents = this.localAgents.values();
        int j = 0;
        while (j < allLocalAgents.length) {
            allLocalAgents[j].removePlatformAddress(address);
            ++j;
        }
        this.theAMS.removeAddresses(address);
        this.theDefaultDF.removeAddresses(address);
    }

    public boolean postMessageToLocalAgent(ACLMessage msg, AID receiverID) {
        Agent receiver = this.localAgents.acquire(receiverID);
        if (receiver == null) {
            return false;
        }
        receiver.postMessage(msg);
        this.localAgents.release(receiverID);
        return true;
    }

    public boolean livesHere(AID id) {
        String hap = id.getHap();
        return CaseInsensitiveString.equalsIgnoreCase(hap, AID.getPlatformID());
    }

    public ContainerID getID() {
        return this.myID;
    }

    public MainContainer getMain() {
        return null;
    }

    public ServiceManager getServiceManager() {
        return this.myServiceManager;
    }

    public ServiceFinder getServiceFinder() {
        return this.myServiceFinder;
    }

    protected ServiceDescriptor startService(String name, boolean activateIt) throws ServiceException {
        try {
            Class<?> svcClass = Class.forName(name);
            Service svc = (Service)svcClass.newInstance();
            svc.init(this, this.myProfile);
            ServiceDescriptor dsc = new ServiceDescriptor(svc.getName(), svc);
            if (activateIt) {
                this.myServiceManager.activateService(dsc);
                svc.boot(this.myProfile);
            }
            return dsc;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServiceException("An error occurred during service activation", t);
        }
    }

    protected void stopService(String name) throws ServiceException {
        try {
            this.myServiceManager.deactivateService(name);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServiceException("An error occurred during service deactivation", t);
        }
    }

    public void becomeLeader() {
    }

    private void initCredentials(Command cmd, AID id) {
    }
}

